package dispatchers

import (
	"google.golang.org/protobuf/proto"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/komod/trips/internal/services"
	"a.yandex-team.ru/travel/orders/proto/order"
)

const defaultRetriesCount = 3

type Orders struct {
	*base
	logger log.Logger
}

func NewOrders(
	logger log.Logger,
	processorService services.Processor,
	unprocessedEntityService services.UnprocessedOrders,
) *Orders {
	logger = logger.WithName("collector.dispatchers.Orders")
	return &Orders{
		base:   newBase(logger, processorService, unprocessedEntityService),
		logger: logger,
	}
}

func (c *Orders) Dispatch(message []byte) error {
	updateEvent := new(order.OrderUpdatedEvent)
	err := proto.Unmarshal(message, updateEvent)
	if err != nil {
		c.logger.Error("unexpected proto format", log.Binary("message", message))
		return nil
	}
	c.logger.Info(
		"got order update from travel-orders",
		log.String("orderID", updateEvent.OrderId),
		log.Time("updatedAt", updateEvent.UpdatedAt.AsTime()),
	)
	c.dispatchOrder(updateEvent.OrderId, updateEvent.UpdatedAt, defaultRetriesCount)
	return nil
}
