package dispatchers

import (
	"google.golang.org/protobuf/proto"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/komod/trips/api/processor/v1"
	"a.yandex-team.ru/travel/komod/trips/internal/services"
)

type UnprocessedOrders struct {
	*base
	logger log.Logger
}

func NewUnprocessedOrders(
	logger log.Logger,
	processorService services.Processor,
	unprocessedEntityService services.UnprocessedOrders,
) *UnprocessedOrders {
	logger = logger.WithName("collector.dispatchers.UnprocessedOrders")
	return &UnprocessedOrders{
		base:   newBase(logger, processorService, unprocessedEntityService),
		logger: logger,
	}
}

func (c *UnprocessedOrders) Dispatch(message []byte) error {
	req := new(processor.ProcessTripEntityReq)
	err := proto.Unmarshal(message, req)
	if err != nil {
		c.logger.Error("unexpected proto format", log.Binary("message", message))
		return nil
	}
	if order := req.GetOrder(); order != nil {
		c.dispatchOrder(order.Id, req.GetCollectedAt(), req.RetriesLeft)
	} else {
		c.logger.Error("unexpected collected entity", log.Binary("message", message))
	}
	return nil
}
