package collector

import (
	"time"

	"google.golang.org/grpc/balancer"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	hcbalancer "a.yandex-team.ru/travel/library/go/grpcutil/client/healthcheck_balancer"
	tvmutil "a.yandex-team.ru/travel/library/go/tvm"
)

func init() {
	processorHealthCheckServiceName := "travel-trips-processor"
	logger, _ := zap.NewDeployLogger(log.DebugLevel)
	balancer.Register(
		hcbalancer.NewBalancerBuilder(
			hcbalancer.WithLogger(logger.WithName("ProcessorBalancer")),
			hcbalancer.WithHealthCheckServiceName(processorHealthCheckServiceName),
			hcbalancer.WithHealthCheckInterval(2000*time.Millisecond),
			hcbalancer.WithBalancingMethod(hcbalancer.BalancingMethodRoundRobin),
			hcbalancer.WithTVMProvider(
				func() (*tvmutil.TvmHelper, uint32) {
					tvmHelper := tvmutil.NewDeployTvmHelper(
						logger,
						&tvmutil.TvmHelperConfig{
							SelfID:    Cfg.Tvm.SelfAppID,
							WhiteList: Cfg.Tvm.Whitelist,
						},
					)
					return &tvmHelper, Cfg.Processor.TvmID
				},
			),
		),
	)
}
