package collector

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/komod/trips/internal/components/collector/dispatchers"
	lbconfig "a.yandex-team.ru/travel/komod/trips/internal/logbroker"
	"a.yandex-team.ru/travel/komod/trips/internal/services"
	logbroker "a.yandex-team.ru/travel/library/go/logbroker/multi"
	"a.yandex-team.ru/travel/library/go/services/messagecollector"
)

func BuildCollector(
	logger log.Logger,
	cfg Config,
	logbrokerConfig lbconfig.LogbrokerConfig,
	processorService services.Processor,
	unprocessedOrdersService services.UnprocessedOrders,
) *messagecollector.Collector {
	return messagecollector.NewCollector(logger).
		Route(
			cfg.OrdersCollectorEnabled,
			messagecollector.NewLogbrockerSource(
				logbroker.NewMultiEndpointConsumer(logger, cfg.OrdersCollector.Consumer, logbrokerConfig.Token),
			),
			dispatchers.NewOrders(
				logger,
				processorService,
				unprocessedOrdersService,
			),
			messagecollector.WithLimiter(messagecollector.NewRPSLimiter(cfg.OrdersCollectorRPSLimit)),
			messagecollector.WithLimiter(messagecollector.NewInflightLimiter(cfg.OrdersCollectorInflightLimit)),
		).
		Route(
			cfg.UnprocessedOrdersCollectorEnabled,
			messagecollector.NewLogbrockerSource(
				logbroker.NewMultiEndpointConsumer(logger, cfg.UnprocessedOrdersCollector.Consumer, logbrokerConfig.Token),
			),
			dispatchers.NewUnprocessedOrders(
				logger,
				processorService,
				unprocessedOrdersService,
			),
			messagecollector.WithLimiter(messagecollector.NewRPSLimiter(cfg.UnprocessedOrdersCollectorRPSLimit)),
			messagecollector.WithLimiter(messagecollector.NewInflightLimiter(cfg.UnprocessedOrdersCollectorInflightLimit)),
		).
		Route(
			cfg.OldOrdersCollectorEnabled,
			messagecollector.NewLogbrockerSource(
				logbroker.NewMultiEndpointConsumer(
					logger,
					overrideMaxReadMessages(cfg.OldOrdersCollector.Consumer, cfg.OldOrdersCollectorMaxReadMessages),
					logbrokerConfig.Token,
				),
			),
			dispatchers.NewOldOrders(logger, processorService, unprocessedOrdersService),
			messagecollector.WithLimiter(messagecollector.NewRPSLimiter(cfg.OldOrdersCollectorRPSLimit)),
			messagecollector.WithLimiter(messagecollector.NewInflightLimiter(cfg.OldOrdersCollectorInflightLimit)),
		)
}

func overrideMaxReadMessages(config logbroker.ConsumerConfig, messages uint32) logbroker.ConsumerConfig {
	if messages > 0 {
		config.Topic.MaxReadMessagesCount = messages
	}
	return config
}
