package processor

import (
	"time"

	"a.yandex-team.ru/travel/avia/library/go/probes"
	"a.yandex-team.ru/travel/komod/trips/internal/common/dynamicresources"
	"a.yandex-team.ru/travel/komod/trips/internal/common/profiling"
	"a.yandex-team.ru/travel/komod/trips/internal/common/tvm"
	"a.yandex-team.ru/travel/komod/trips/internal/db"
	"a.yandex-team.ru/travel/komod/trips/internal/orders/clients"
	"a.yandex-team.ru/travel/komod/trips/internal/references"
	"a.yandex-team.ru/travel/komod/trips/internal/trips/matcher"
	"a.yandex-team.ru/travel/komod/trips/internal/unifiedagent"
	"a.yandex-team.ru/travel/library/go/geobase"
	grpcserver "a.yandex-team.ru/travel/library/go/grpcutil/server"
	httpserver "a.yandex-team.ru/travel/library/go/httputil/server"
	"a.yandex-team.ru/travel/library/go/logging"
)

type Config struct {
	EnvType            string `config:"YENV_TYPE,required" yaml:"yenv_type"`
	Dicts              references.Config
	DynamicResources   dynamicresources.Config `yaml:"dynamic_resources"`
	Logging            logging.Config
	Grpc               grpcserver.GrpcConfig
	HTTP               httpserver.HTTPConfig
	Tvm                tvm.Config
	Probes             probes.HTTPConfig
	Profiling          profiling.Config
	Geobase            geobase.Config
	OrdersClient       clients.Config `yaml:"orders_client"`
	Database           db.Config
	TransactionOptions db.TransactionOptions
	ProcessingTimeout  time.Duration       `yaml:"processing_timeout"`
	UnifiedAgent       unifiedagent.Config `yaml:"unified_agent"`
	ProcessBusOrders   bool                `config:"PROCESS_BUS_ORDERS" yaml:"process_bus_orders"`
	Matcher            matcher.Config
}

var Cfg = Config{
	EnvType:            "development",
	Dicts:              references.DefaultConfig,
	DynamicResources:   dynamicresources.DefaultConfig,
	Logging:            logging.DefaultConfig,
	Grpc:               grpcserver.DefaultGrpcConfig,
	HTTP:               httpserver.DefaultHTTPConfig,
	Tvm:                tvm.DefaultConfig,
	Probes:             probes.DefaultHTTPConfig,
	Profiling:          profiling.DefaultConfig,
	Geobase:            geobase.DefaultConfig,
	OrdersClient:       clients.DefaultHTTPConfig,
	Database:           db.DefaultConfig,
	TransactionOptions: db.DefaultTransactionOptions,
	ProcessingTimeout:  10 * time.Second,
	UnifiedAgent:       unifiedagent.DefaultConfig,
	ProcessBusOrders:   true,
	Matcher:            matcher.DefaultConfig,
}
