package eventslogger

import (
	"time"

	"a.yandex-team.ru/travel/komod/trips/internal/models"
	"a.yandex-team.ru/travel/komod/trips/internal/point"
)

type marshalableSpan struct {
	Start       marshalableVisit `yson:"start"`
	End         marshalableVisit `yson:"end"`
	IsTransport bool             `yson:"isTransport"`
	Duration    time.Duration    `yson:"duration"`
}

func newMarshalableSpan(s models.Span) marshalableSpan {
	return marshalableSpan{
		Start:       newMarshalableVisit(s.Start()),
		End:         newMarshalableVisit(s.End()),
		IsTransport: s.IsTransport(),
		Duration:    s.Duration(),
	}
}

type marshalableVisit struct {
	PointKey string    `yson:"pointKey"`
	Time     time.Time `yson:"time"`
}

func newMarshalableVisit(v models.Visit) marshalableVisit {
	return marshalableVisit{
		PointKey: point.ExtractPointKey(v.Point()),
		Time:     v.When(),
	}
}
