package grpc

import (
	"context"
	"fmt"
	"time"

	"google.golang.org/grpc"

	protoapi "a.yandex-team.ru/travel/komod/trips/api/processor/v1"
	"a.yandex-team.ru/travel/komod/trips/internal/components/processor"
	"a.yandex-team.ru/travel/komod/trips/internal/orders"
)

type Service struct {
	processor         *processor.Processor
	processingTimeout time.Duration
}

func NewService(processor *processor.Processor, processingTimeout time.Duration) *Service {
	return &Service{
		processor:         processor,
		processingTimeout: processingTimeout,
	}
}

func (s *Service) GetServiceRegisterer() func(*grpc.Server) {
	return func(server *grpc.Server) {
		protoapi.RegisterProcessorServiceV1Server(server, s)
	}
}

func (s *Service) ProcessTripEntity(ctx context.Context, req *protoapi.ProcessTripEntityReq) (*protoapi.ProcessTripEntityRsp, error) {
	ctx, cancel := context.WithTimeout(ctx, s.processingTimeout)
	defer cancel()
	if entity := req.GetOrder(); entity != nil {
		return &protoapi.ProcessTripEntityRsp{}, s.processor.ProcessOrder(
			ctx,
			orders.ID(entity.GetId()),
			req.CollectedAt.AsTime(),
		)
	}
	return nil, fmt.Errorf("unexpected trip entity")
}
