package processor

import (
	"time"

	"a.yandex-team.ru/library/go/core/metrics"
	travelmetrics "a.yandex-team.ru/travel/library/go/metrics"
)

const (
	metricsPrefix = "processor"
)

type Metrics struct {
	orderDeliveryLag metrics.Timer
}

func NewMetrics() Metrics {
	return Metrics{
		orderDeliveryLag: travelmetrics.GlobalAppMetrics().GetOrCreateHistogram(
			metricsPrefix,
			nil,
			"order_delivery_lag",
			metrics.MakeExponentialDurationBuckets(100*time.Millisecond, 1.2, 40), // 0.1 ... 122 seconds
		),
	}
}
