package consts

import "time"

const (
	EkbLocationName = "Asia/Yekaterinburg"
	IstLocationName = "Europe/Istanbul"
	MskLocationName = "Europe/Moscow"

	ISO8601OutputTimeFormat = "2006-01-02T15:04:05.999999999Z"

	Day = 24 * time.Hour
)

var (
	EkbLocation = mustLoadLocation(EkbLocationName)
	IstLocation = mustLoadLocation(IstLocationName)
	MskLocation = mustLoadLocation(MskLocationName)
)

func mustLoadLocation(name string) *time.Location {
	if loc, err := time.LoadLocation(name); err != nil {
		panic("got error during parsing location: " + err.Error())
	} else {
		return loc
	}
}
