package db

import (
	"time"
)

type Config struct {
	Hosts              []string      `config:"DATABASE_HOSTS,required" yaml:"hosts"`
	Port               int           `config:"DATABASE_PORT,required" yaml:"port"`
	User               string        `config:"DATABASE_USER,required" yaml:"user"`
	Password           string        `config:"DATABASE_PASSWORD,required" yaml:"password"`
	Name               string        `config:"DATABASE_NAME,required" yaml:"name"`
	HostsUpdateTimeout time.Duration `config:"DATABASE_HOSTS_UPDATE_TIMEOUT" yaml:"hosts_update_timeout"`
}

type TransactionOptions struct {
	StatementTimeout                time.Duration
	LockTimeout                     time.Duration
	IdleInTransactionSessionTimeout time.Duration
	WaitForLock                     bool
}

var (
	DefaultConfig = Config{
		Port:               6432,
		User:               "trips-app",
		Name:               "trips",
		HostsUpdateTimeout: 5 * time.Second,
	}
	DefaultTransactionOptions = TransactionOptions{
		StatementTimeout:                5 * time.Second,
		LockTimeout:                     3 * time.Second,
		IdleInTransactionSessionTimeout: 10 * time.Second,
		WaitForLock:                     true,
	}
)
