package db

import (
	"time"
)

var AllModels = []interface{}{
	&User{},
	&Trip{},
	&OrderSpan{},
	&UnprocessedOrder{},
}

type User struct {
	PassportID string    `gorm:"primaryKey"`
	Trip       Trip      `gorm:"foreignKey:PassportID;references:PassportID"`
	OrderSpan  OrderSpan `gorm:"foreignKey:PassportID;references:PassportID"`
}

type Trip struct {
	ID         string `gorm:"primaryKey"`
	PassportID string
}

type OrderSpan struct {
	ID                uint64 `gorm:"primaryKey"`
	PassportID        string `gorm:"index:order_spans_passport_id_key"`
	TripID            string `gorm:"index:order_spans_trip_id_key"`
	OrderID           string `gorm:"index:order_spans_order_id_key"`
	Cancelled         bool
	StartPoint        string
	EndPoint          string
	StartTime         time.Time
	EndTime           time.Time
	IsTransport       bool
	MatcherVersion    int
	Trip              Trip  `gorm:"foreignKey:TripID;references:ID"`
	DisplayOrderState uint8 `gorm:"default:0"`
}

type UnprocessedOrder struct {
	ID        string `gorm:"primaryKey"`
	CreatedAt time.Time
	UpdatedAt time.Time
}
