package db

import (
	"time"

	"a.yandex-team.ru/travel/komod/trips/internal/models"
)

type mappedSpan struct {
	id          uint64
	start, end  models.Visit
	isTransport bool
	duration    time.Duration
}

func newMappedSpan(id uint64, start models.Visit, end models.Visit, isTransport bool) *mappedSpan {
	return &mappedSpan{id: id, start: start, end: end, isTransport: isTransport, duration: end.When().Sub(start.When())}
}

func (s mappedSpan) Start() models.Visit {
	return s.start
}

func (s mappedSpan) End() models.Visit {
	return s.end
}

func (s mappedSpan) IsTransport() bool {
	return s.isTransport
}

func (s mappedSpan) Duration() time.Duration {
	return s.duration
}
