package db

import (
	"golang.yandex/hasql"
	"gorm.io/gorm"

	"a.yandex-team.ru/travel/komod/trips/internal/pgclient"
	"a.yandex-team.ru/travel/komod/trips/internal/point"
	"a.yandex-team.ru/travel/komod/trips/internal/trips"
)

type TripsStorage struct {
	txOptions           TransactionOptions
	pgClient            *pgclient.Client
	objectsModelsMapper ObjectsModelsMapper
}

func NewTripsStorage(transactionOptions TransactionOptions, pgClient *pgclient.Client, spanVisitFactory *point.Factory) *TripsStorage {
	return &TripsStorage{
		txOptions: transactionOptions,
		pgClient:  pgClient,
		objectsModelsMapper: ObjectsModelsMapper{
			spanVisitFactory: spanVisitFactory,
		},
	}
}

func (s *TripsStorage) GetSession() trips.StorageSession {
	db, err := s.pgClient.GetDB(hasql.Alive)
	if err != nil {
		return BadSession{}
	}
	return &Session{
		db:      db,
		storage: s,
	}
}

func (s *TripsStorage) Execute(txBody func(trips.StorageSession) error) error {
	return s.pgClient.ExecuteInTransaction(
		hasql.Alive,
		func(db *gorm.DB) error {
			return txBody(
				&Session{
					db:      db,
					storage: s,
				},
			)
		},
	)
}

func (s *TripsStorage) ExecuteInTransaction(txBody func(trips.StorageTxSession) error) error {
	return s.pgClient.ExecuteInTransaction(
		hasql.Primary,
		func(db *gorm.DB) error {
			return txBody(
				&TxSession{
					txOptions: s.txOptions,
					Session: Session{
						db:      db,
						storage: s,
					},
				},
			)
		},
	)
}
