package db

import (
	"context"
	"time"

	"golang.yandex/hasql"
	"gorm.io/gorm"
	"gorm.io/gorm/clause"

	"a.yandex-team.ru/travel/komod/trips/internal/pgclient"
	"a.yandex-team.ru/travel/komod/trips/internal/services/unprocessedorders"
)

type UnprocessedOrdersStorage struct {
	pgClient *pgclient.Client
}

func NewUnprocessedOrdersStorage(pgClient *pgclient.Client) *UnprocessedOrdersStorage {
	return &UnprocessedOrdersStorage{pgClient: pgClient}
}

func (u *UnprocessedOrdersStorage) Count(ctx context.Context) (int, error) {
	var count int64 = 0
	err := u.pgClient.ExecuteInTransaction(hasql.PreferStandby, func(db *gorm.DB) error {
		return db.WithContext(ctx).Model(&UnprocessedOrder{}).Count(&count).Error
	})
	return int(count), err
}

func (u *UnprocessedOrdersStorage) Upsert(ctx context.Context, order *unprocessedorders.UnprocessedOrder) (bool, error) {
	var existingOrder int64 = 0
	err := u.pgClient.ExecuteInTransaction(hasql.Primary, func(db *gorm.DB) error {
		model := &UnprocessedOrder{
			ID:        order.ID,
			CreatedAt: time.Now().UTC(),
			UpdatedAt: time.Now().UTC(),
		}
		db = db.WithContext(ctx)

		if err := db.Model(&UnprocessedOrder{}).Where("id = ?", order.ID).Count(&existingOrder).Error; err != nil {
			return err
		}
		return db.
			Clauses(clause.OnConflict{
				Columns:   []clause.Column{{Name: "id"}},
				DoUpdates: clause.AssignmentColumns([]string{"updated_at"})}).
			Create(&model).Error
	})
	return existingOrder == 0, err
}
