package extractors

import (
	"strings"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/komod/trips/internal/consts"
	"a.yandex-team.ru/travel/komod/trips/internal/models"
	"a.yandex-team.ru/travel/komod/trips/internal/references"
	"a.yandex-team.ru/travel/komod/trips/internal/services/cityimages"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

const origImageSuffix = "/orig"

type PointImagesExtractor struct {
	logger            log.Logger
	cityImagesService *cityimages.Service
	references        references.References
}

func NewPointImagesExtractor(
	logger log.Logger,
	cityImagesService *cityimages.Service,
	references references.References,
) *PointImagesExtractor {
	return &PointImagesExtractor{
		logger:            logger.WithName("extractors.PointImagesExtractor"),
		cityImagesService: cityImagesService,
		references:        references,
	}
}

func (e PointImagesExtractor) Extract(point models.Point, alias consts.ImageAlias) string {
	var settlement *rasp.TSettlement
	if point.GetKind() == models.SettlementPointKind {
		settlement, _ = e.references.Settlements().Get(point.GetID())
	} else {
		geoID := point.GetGeoID()
		if geoID == 0 {
			return ""
		}
		var found bool
		settlement, found = e.references.Settlements().GetByGeoID(geoID)
		if !found || settlement.GetId() <= 0 {
			return ""
		}
	}
	id := int(settlement.Id)
	url := e.cityImagesService.GetURL(id)
	if url == "" {
		return ""
	}
	return strings.TrimSuffix(url, origImageSuffix) + "/" + string(alias)
}
