package extractors

import (
	"a.yandex-team.ru/travel/komod/trips/internal/references"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type StationIDToSettlementIDMapper struct {
	references references.References
}

func NewStationIDToSettlementIDMapper(references references.References) *StationIDToSettlementIDMapper {
	return &StationIDToSettlementIDMapper{references: references}
}

func (s StationIDToSettlementIDMapper) Map(stationID int32) (settlementID int32, found bool) {
	if stationToSettlement, ok := s.references.StationToSettlements().Get(int(stationID)); ok && stationToSettlement.SettlementId > 0 {
		return stationToSettlement.SettlementId, true
	}
	if station, ok := s.references.Stations().Get(int(stationID)); ok && station.SettlementId > 0 {
		return station.SettlementId, true
	}
	return 0, false
}

type SettlementByStationExtractor struct {
	references                    references.References
	stationIDToSettlementIDMapper *StationIDToSettlementIDMapper
}

func NewSettlementByStationExtractor(references references.References) *SettlementByStationExtractor {
	return &SettlementByStationExtractor{
		references:                    references,
		stationIDToSettlementIDMapper: NewStationIDToSettlementIDMapper(references),
	}
}

func (s SettlementByStationExtractor) Get(stationID int32) (settlement *rasp.TSettlement, found bool) {
	var settlementID int32
	if station, ok := s.references.Stations().Get(int(stationID)); ok && station.SettlementId > 0 {
		settlementID = station.SettlementId
	} else if stationToSettlement, ok := s.references.StationToSettlements().Get(int(stationID)); ok && stationToSettlement.SettlementId > 0 {
		settlementID = stationToSettlement.SettlementId
	}
	if settlement, ok := s.references.Settlements().Get(int(settlementID)); ok {
		return settlement, true
	}
	return nil, false
}
