package extractors

import (
	"fmt"

	"a.yandex-team.ru/travel/komod/trips/internal/references"
)

type SettlementExtractor struct {
	settlementIDByStationID *StationIDToSettlementIDMapper
	references              references.References
}

func NewSettlementExtractor(settlementIDByStationID *StationIDToSettlementIDMapper, references references.References) *SettlementExtractor {
	return &SettlementExtractor{settlementIDByStationID: settlementIDByStationID, references: references}
}

func (s *SettlementExtractor) GetSettlementIDByCode(code string) (uint64, error) {
	if settlementID, err := s.getBySettlementCode(code); err == nil {
		return settlementID, nil
	}
	return s.getByStationCode(code)
}

func (s *SettlementExtractor) getBySettlementCode(settlementCode string) (uint64, error) {
	settlement, found := s.references.Settlements().GetByCode(settlementCode)
	if !found {
		return 0, fmt.Errorf("unknown settlement code")
	}
	return uint64(settlement.Id), nil
}

func (s *SettlementExtractor) getByStationCode(stationCode string) (uint64, error) {
	stationID, found := s.references.StationCodes().GetStationIDByCode(stationCode)
	if !found {
		return 0, fmt.Errorf("unknown station code")
	}
	settlementID, found := s.settlementIDByStationID.Map(stationID)
	if !found {
		return 0, fmt.Errorf("station has no settlement")
	}
	return uint64(settlementID), nil
}
