package helpers

import (
	"fmt"
	"time"

	"golang.org/x/net/context"
	"google.golang.org/grpc"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/library/go/grpcutil/client/ypresolver"
	tvmutil "a.yandex-team.ru/travel/library/go/tvm"
)

func CreateConnection(yPlannerID string, tvmID uint32, logger log.Logger, tvmHelper *tvmutil.TvmHelper) (*grpc.ClientConn, error) {
	tvmInterceptor := tvmHelper.GRPCClientInterceptor(tvmID)
	if tvmInterceptor == nil {
		return nil, fmt.Errorf("failed to create tvm interceptor for readiness server")
	}
	ctx := context.Background()
	ctx, cancel := context.WithTimeout(ctx, 90*time.Second)
	defer cancel()
	resolver := ypresolver.NewYPResolverBuilder(ypresolver.WithLogger(logger.Structured()))
	return grpc.DialContext(
		ctx,
		ypresolver.BuildServiceFQDN(yPlannerID),
		grpc.WithResolvers(resolver),
		grpc.WithDefaultServiceConfig("{\"loadBalancingPolicy\":\"healthcheck_balancer\"}"),
		grpc.WithInsecure(),
		grpc.WithBlock(),
		grpc.WithUnaryInterceptor(tvmInterceptor),
	)
}
