package http

import "fmt"

var (
	ErrNoUserCredentials = fmt.Errorf("no user credentials were provided")
)

type RequestErr struct {
	err error
}

func (e RequestErr) Error() string {
	return fmt.Errorf("error while http requesting: %w", e.err).Error()
}

type NotFoundErr struct {
	content string
}

func NewNotFoundErr(content string) error {
	return &NotFoundErr{content: content}
}

func (e NotFoundErr) Error() string {
	return e.content
}
