package http

import (
	"time"

	"github.com/cenkalti/backoff/v4"
)

type Option func(fetcher *Fetcher)

func withDefaultBackOffPolicy(fetcher *Fetcher) {
	defaultBackOff := backoff.ExponentialBackOff{
		InitialInterval:     100 * time.Millisecond,
		RandomizationFactor: backoff.DefaultRandomizationFactor,
		Multiplier:          backoff.DefaultMultiplier,
		MaxInterval:         600 * time.Millisecond,
		MaxElapsedTime:      5 * time.Second,
		Clock:               backoff.SystemClock,
		Stop:                backoff.Stop,
	}
	fetcher.backOffPolicyGetter = func() backoff.BackOff {
		b := defaultBackOff
		return &b
	}
}

func withDefaultRequestTimeout(fetcher *Fetcher) {
	fetcher.requestTimeout = 5 * time.Second
}

func WithBackOffPolicy(backOffPolicyGetter func() backoff.BackOff) Option {
	return func(fetcher *Fetcher) {
		fetcher.backOffPolicyGetter = backOffPolicyGetter
	}
}

func WithRequestTimeout(timeout time.Duration) Option {
	return func(fetcher *Fetcher) {
		fetcher.requestTimeout = timeout
	}
}
