package helpers

import (
	"sync"
	"time"
)

type CachedLocationRepository struct {
	cache sync.Map
}

func NewCachedLocationRepository() *CachedLocationRepository {
	return &CachedLocationRepository{}
}

func (repository *CachedLocationRepository) LoadLocation(location string) (*time.Location, error) {
	if loc, ok := repository.cache.Load(location); ok {
		return loc.(*time.Location), nil
	}
	loc, err := time.LoadLocation(location)
	if err == nil {
		repository.cache.Store(location, loc)
	}
	return loc, err
}
