package helpers

import (
	"time"

	"google.golang.org/grpc"

	"a.yandex-team.ru/library/go/core/metrics"
	grpcmetrics "a.yandex-team.ru/travel/library/go/grpcutil/metrics"
)

// TimingsBuckets
// min = 10ms
// max = ~10s
var TimingsBuckets = metrics.MakeExponentialDurationBuckets(10*time.Millisecond, 1.2, 40)

func MakeMetricsInterceptor(rootRegistry metrics.Registry) grpc.UnaryServerInterceptor {
	return grpcmetrics.NewGrpcMetricsInterceptor(
		rootRegistry,
		grpcmetrics.WithDurationBuckets(TimingsBuckets),
	)
}
