package middlewares

import (
	"github.com/go-chi/chi/v5/middleware"

	"a.yandex-team.ru/library/go/core/log"
)

type RateLimiterArgs struct {
	Logger log.Logger
	Limit  int
}

func RateLimiter(args RateLimiterArgs) *Router {
	return New(
		args.Logger,
		middleware.Throttle(args.Limit),
	)
}
