package middlewares

import (
	"a.yandex-team.ru/library/go/core/log"
	tvmutil "a.yandex-team.ru/library/go/httputil/middleware/tvm"
	"a.yandex-team.ru/library/go/yandex/tvm"
)

type TvmArgs struct {
	AllowClientIDs []uint32
	Logger         log.Logger
	TvmClient      tvm.Client
}

func Tvm(args TvmArgs) *Router {
	var mw Middleware
	if args.TvmClient != nil {
		mw = tvmutil.CheckServiceTicket(
			args.TvmClient,
			tvmutil.WithAllowedClients(convertToClientID(args.AllowClientIDs)),
			tvmutil.WithLogger(args.Logger.Structured()),
		)
	}
	return New(args.Logger, mw)
}

func convertToClientID(clientIDs []uint32) (result []tvm.ClientID) {
	for _, id := range clientIDs {
		result = append(result, tvm.ClientID(id))
	}
	return result
}
