package models

import (
	"time"
)

type Span interface {
	Start() Visit
	End() Visit
	IsTransport() bool
	Duration() time.Duration
}

type naiveImpl struct {
	start       Visit
	end         Visit
	isTransport bool
	duration    time.Duration
}

func NewSpan(start, end Visit, isTransport bool) Span {
	return &naiveImpl{
		start:       start,
		end:         end,
		isTransport: isTransport,
		duration:    end.When().Sub(start.When()),
	}
}

func (o *naiveImpl) Start() Visit {
	return o.start
}

func (o *naiveImpl) End() Visit {
	return o.end
}

func (o *naiveImpl) IsTransport() bool {
	return o.isTransport
}

func (o *naiveImpl) Duration() time.Duration {
	return o.duration
}
