package models

import (
	"time"
)

type Visit struct {
	point Point
	when  time.Time
}

func NewVisit(point Point, when time.Time) Visit {
	if point != nil {
		timezone := point.GetTimezone()
		if timezone != nil {
			when = when.In(timezone)
		}
	}
	return Visit{point: point, when: when}
}

func (v Visit) When() time.Time {
	return v.when
}

func (v Visit) Point() Point {
	return v.point
}

func NewFakeVisit(id int, when time.Time) Visit {
	return Visit{
		point: NewFakePoint(id),
		when:  when,
	}
}
