package notifier

import (
	"time"
)

type Config struct {
	Enabled            bool          `config:"NOTIFIER_ENABLED" yaml:"enabled"`
	RequestTimeout     time.Duration `config:"NOTIFIER_REQUEST_TIMEOUT" yaml:"request_timeout"`
	TvmID              uint32        `config:"NOTIFIER_TVM_ID" yaml:"tvm_id"`
	YPlannerID         string        `config:"NOTIFIER_Y_PLANNER_ID" yaml:"y_planner_id"`
	ConnectionsPerHost uint          `config:"NOTIFIER_CONNECTIONS_PER_HOST" yaml:"connections_per_host"`
}

var DefaultConfig = Config{
	Enabled:            false,
	RequestTimeout:     3 * time.Second,
	TvmID:              2025412,
	YPlannerID:         "travel-notifier-testing.api",
	ConnectionsPerHost: 5,
}
