package orders

import (
	"context"
)

type ID string

func (i ID) String() string {
	return string(i)
}

func IDs(ids ...string) []ID {
	result := make([]ID, 0, len(ids))
	for _, id := range ids {
		result = append(result, ID(id))
	}
	return result
}

type Client interface {
	GetOrderNoAuth(ctx context.Context, orderID ID) (Order, error)
	GetOrdersByIDs(ctx context.Context, orderIDs ...ID) ([]Order, error)
	GetUserOrdersWithoutExcluded(ctx context.Context, passportID string, excludedIDs ...ID) ([]Order, string, error)
	GetUserOrdersWithoutExcludedNextPage(ctx context.Context, nextPageToken string) ([]Order, string, error)
}
