package clients

import "fmt"

var (
	ErrNoUserCredentials = fmt.Errorf("no user credentials were provided")
)

type RequestTravelAPIErr struct {
	err error
}

func (e RequestTravelAPIErr) Error() string {
	return fmt.Errorf("error while requesting travel api: %w", e.err).Error()
}

type TravelAPINotFoundErr struct {
	content string
}

func NewTravelAPINotFoundErr(content string) error {
	return &TravelAPINotFoundErr{content: content}
}

func (e TravelAPINotFoundErr) Error() string {
	return e.content
}
