package clients

import (
	"fmt"
	"time"

	"a.yandex-team.ru/travel/komod/trips/internal/helpers"
	"a.yandex-team.ru/travel/library/go/metrics"
)

type HTTPMetrics struct {
	prefix string
}

func NewHTTPMetrics(prefix string) *HTTPMetrics {
	return &HTTPMetrics{prefix: prefix}
}

func (m *HTTPMetrics) SendRequestMetrics(url string, startTime time.Time, isRequestSuccess bool) {
	requestStatusCode := "ok"
	if !isRequestSuccess {
		requestStatusCode = "fail"
	}

	countMetricsName := fmt.Sprintf("request.%s.count", requestStatusCode)
	metrics.GlobalAppMetrics().GetOrCreateCounter(
		m.prefix,
		map[string]string{
			"url": url,
		},
		countMetricsName,
	).Inc()

	durationMetricsName := fmt.Sprintf("request.%s.duration", requestStatusCode)
	metrics.GlobalAppMetrics().GetOrCreateHistogram(
		m.prefix,
		map[string]string{
			"url": url,
		},
		durationMetricsName,
		helpers.TimingsBuckets,
	).RecordDuration(time.Since(startTime))
}
