package clients

import (
	"time"

	"github.com/cenkalti/backoff/v4"
)

type Option func(*HTTPClient)

func withBackOffPolicy(elapsedTime time.Duration) Option {
	return func(client *HTTPClient) {
		defaultBackOff := backoff.ExponentialBackOff{
			InitialInterval:     100 * time.Millisecond,
			RandomizationFactor: backoff.DefaultRandomizationFactor,
			Multiplier:          backoff.DefaultMultiplier,
			MaxInterval:         600 * time.Millisecond,
			MaxElapsedTime:      elapsedTime,
			Clock:               backoff.SystemClock,
			Stop:                backoff.Stop,
		}
		client.backOffPolicyGetter = func() backoff.BackOff {
			b := defaultBackOff
			return &b
		}
	}
}
