package clients

import (
	"a.yandex-team.ru/travel/komod/trips/internal/orders"
	ordermodels "a.yandex-team.ru/travel/komod/trips/internal/orders/models"
)

type selectOrdersReq struct {
	OrderIDs []orders.ID `json:"order_ids"`
}

type selectOrdersRsp struct {
	Orders []ordermodels.OrderItem `json:"orders"`
}

type getOrderRsp struct {
	Order ordermodels.OrderItem `json:"order"`
}

type getOrdersWithoutExcludedReq struct {
	ExcludedOrderIds         []orders.ID `json:"excluded_order_ids"`
	PageSize                 int         `json:"page_size"`
	DisplayableOrderStatuses []string    `json:"displayable_order_statuses"`
	OrderTypes               []string    `json:"order_types"`
}

type getOrdersWithoutExcludedNextPageReq struct {
	NextPageToken string `json:"next_page_token"`
}

func newGetOrdersWithoutExcludedReq(excludedOrderIds []orders.ID, pageSize int) *getOrdersWithoutExcludedReq {
	return &getOrdersWithoutExcludedReq{
		ExcludedOrderIds:         excludedOrderIds,
		PageSize:                 pageSize,
		DisplayableOrderStatuses: []string{},
		OrderTypes:               []string{},
	}
}

type getOrdersWithoutExcludedRsp struct {
	Orders        []ordermodels.OrderItem `json:"orders"`
	HasMoreOrders bool                    `json:"has_more_orders"`
	NextPageToken string                  `json:"next_page_token"`
}
