package mappers

import "fmt"

var (
	ErrUnexpectedSegmentsNumber = fmt.Errorf("order contains unexpected number of segments")
	ErrUnexpectedFlightsNumber  = fmt.Errorf("avia order contains unexpected number of flights")
)

type ErrHotelNotFound struct {
	permalink uint64
}

func NewErrHotelNotFound(permalink uint64) error {
	return &ErrHotelNotFound{permalink: permalink}
}

func (e ErrHotelNotFound) Error() string {
	return fmt.Sprintf("hotel with permalink %d not found", e.permalink)
}

type ErrSettlementNotFound struct {
	id int
}

func NewErrSettlementNotFound(id int) error {
	return &ErrSettlementNotFound{id: id}
}

func (e ErrSettlementNotFound) Error() string {
	return fmt.Sprintf("unable to find settlement by id %d", e.id)
}

type ErrStationNotFound struct {
	id int
}

func NewErrStationNotFound(id int) error {
	return &ErrStationNotFound{id: id}
}

func (e ErrStationNotFound) Error() string {
	return fmt.Sprintf("unable to find station by id %d", e.id)
}

type ErrStationWithoutSettlement struct {
	id int
}

func NewErrStationWithoutSettlement(id int) error {
	return &ErrStationWithoutSettlement{id: id}
}

func (e ErrStationWithoutSettlement) Error() string {
	return fmt.Sprintf("unable to find settlement for station id %d", e.id)
}

type ErrSettlementNotFoundByStation struct {
	stationID int
}

func NewErrSettlementNotFoundByStation(stationID int) error {
	return &ErrSettlementNotFoundByStation{stationID: stationID}
}

func (e ErrSettlementNotFoundByStation) Error() string {
	return fmt.Sprintf("unable to find settlement by stationID %d", e.stationID)
}

type ErrSettlementNotFoundByGeo struct {
	id int
}

func NewErrSettlementNotFoundByGeo(id int) error {
	return &ErrSettlementNotFoundByGeo{id: id}
}

func (e ErrSettlementNotFoundByGeo) Error() string {
	return fmt.Sprintf("unable to find settlement by geoID %d", e.id)
}

type ErrCarrierNotFound struct {
	id int
}

func NewErrCarrierNotFound(id int) error {
	return &ErrCarrierNotFound{id: id}
}

func (e ErrCarrierNotFound) Error() string {
	return fmt.Sprintf("unable to find carrier by id %d", e.id)
}

type ErrNoBusRides struct {
	orderID string
}

func NewErrNoBusRides(orderID string) error {
	return &ErrNoBusRides{orderID: orderID}
}

func (e ErrNoBusRides) Error() string {
	return fmt.Sprintf("unable to find carrier for order id: %s", e.orderID)
}

type ErrUnexpectedBusPointType struct {
	pointType string
}

func NewErrUnexpectedBusPointType(pointType string) error {
	return &ErrUnexpectedBusPointType{pointType: pointType}
}

func (e ErrUnexpectedBusPointType) Error() string {
	return fmt.Sprintf("unexpected bus point type: %s", e.pointType)
}
