package models

import (
	"time"

	ordersproto "a.yandex-team.ru/travel/orders/proto"
	travelproto "a.yandex-team.ru/travel/proto"
	"a.yandex-team.ru/travel/proto/dicts/avia"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type Order interface {
	isOrder()
}

type AviaOrder struct {
	Order
	ID              string
	FromSettlement  *rasp.TSettlement
	ToSettlement    *rasp.TSettlement
	Forward         time.Time
	Backward        *time.Time
	PNR             string
	RegistrationURL string
	Airlines        []*avia.TAirline
	State           ordersproto.EDisplayOrderState
}

type Train struct {
	Title       string
	Description string
}

type TrainOrder struct {
	Order
	ID             string
	FromSettlement *rasp.TSettlement
	ToSettlement   *rasp.TSettlement
	Forward        time.Time
	Backward       *time.Time
	Trains         []Train
	PrintURL       string
	State          ordersproto.EDisplayOrderState
}

type HotelOrder struct {
	Order
	ID           string
	Settlement   *rasp.TSettlement
	Title        string
	CheckinDate  time.Time
	CheckoutDate time.Time
	Address      string
	Coordinates  *travelproto.TCoordinates
	State        ordersproto.EDisplayOrderState
}
