package models

type AviaItem struct {
	ID             string            `json:"id"`
	YandexOrderID  string            `json:"yandex_order_id"`
	PassportID     string            `json:"passport_id"`
	Type           OrderType         `json:"type"`
	AirReservation AirReservation    `json:"air_reservation"`
	State          DisplayOrderState `json:"state"`
}

type FlightStop struct {
	AirportID uint64 `json:"airport_id"`
	Terminal  string `json:"terminal"`
}

type Flight struct {
	ID                   string     `json:"id"`
	From                 uint64     `json:"from"`
	To                   uint64     `json:"to"`
	MarketingAviaCompany uint64     `json:"marketing_avia_company"`
	OperatingAviaCompany uint64     `json:"operating_avia_company"`
	Number               string     `json:"number"`
	Arrival              string     `json:"arrival"`
	Departure            string     `json:"departure"`
	Stops                FlightStop `json:"stops"`
}

type AviaSegment struct {
	Flights []Flight `json:"flights"`
}

type AirReservation struct {
	Pnr        string        `json:"pnr"`
	PartnerRef string        `json:"partner_ref"`
	Segments   []AviaSegment `json:"segments"`
}
