package buses

type Ride struct {
	RideID               string   `json:"ride_id"`
	SupplierID           int      `json:"supplier_id"`
	BusPartner           string   `json:"bus_partner"`
	Supplier             Supplier `json:"supplier"`
	CarrierCode          string   `json:"carrier_code"`
	Carrier              Carrier  `json:"carrier"`
	LocalDepartureTime   string   `json:"local_departure_time"`
	LocalArrivalTime     string   `json:"local_arrival_time"`
	Duration             int      `json:"duration"`
	TitlePointFrom       Point    `json:"title_point_from"`
	TitlePointTo         Point    `json:"title_point_to"`
	Bus                  string   `json:"bus"`
	RouteName            string   `json:"route_name"`
	RouteNumber          string   `json:"route_number"`
	DownloadBlankToken   string   `json:"download_blank_token"`
	RefundedTicketsCount uint16   `json:"refunded_tickets_count"`
}

type Carrier struct {
	RegisterType   string `json:"register_type"`
	RegisterNumber string `json:"register_number"`
	Name           string `json:"name"`
	LegalName      string `json:"legal_name"`
	LegalAddress   string `json:"legal_address"`
	ActualAddress  string `json:"actual_address"`
	TaxationNumber string `json:"taxation_number"`
}

type Supplier struct {
	RegisterType   string `json:"register_type"`
	RegisterNumber string `json:"register_number"`
	Name           string `json:"name"`
	LegalName      string `json:"legal_name"`
	LegalAddress   string `json:"legal_address"`
	ActualAddress  string `json:"actual_address"`
	TaxationNumber string `json:"taxation_number"`
	Timetable      string `json:"timetable"`
}

type Point struct {
	Type                PointType `json:"type"`
	ID                  int       `json:"id"`
	PointKey            string    `json:"point_key"`
	SupplierDescription string    `json:"supplier_description"`
	Title               string    `json:"title"`
	Address             string    `json:"address"`
	Timezone            string    `json:"timezone"`
	Longitude           float64   `json:"longitude"`
	Latitude            float64   `json:"latitude"`
	Source              string    `json:"source"`
}

type PointType string

const (
	PointTypeSettlement PointType = "POINT_KEY_TYPE_SETTLEMENT"
	PointTypeStation    PointType = "POINT_KEY_TYPE_STATION"
)
