package models

import (
	"fmt"
	"strings"

	ordercommons "a.yandex-team.ru/travel/orders/proto"
)

type DisplayOrderState ordercommons.EDisplayOrderState

func (e *DisplayOrderState) UnmarshalJSON(bytes []byte) error {
	rawState := strings.Trim(string(bytes), "\"")
	state, ok := ordercommons.EDisplayOrderState_value[rawState]
	if !ok {
		return fmt.Errorf("invalid EDisplayOrderState value")
	}
	*e = DisplayOrderState(state)
	return nil
}

func (e DisplayOrderState) ToProto() ordercommons.EDisplayOrderState {
	return ordercommons.EDisplayOrderState(e)
}
