package models

import (
	"github.com/shopspring/decimal"
)

type HotelItem struct {
	ID               string            `json:"id"`
	YandexOrderID    string            `json:"yandex_order_id"`
	PassportID       string            `json:"passport_id"`
	Type             OrderType         `json:"type"`
	HotelPermalink   uint64            `json:"hotel_permalink"`
	HotelName        string            `json:"hotel_name"`
	CheckinDate      string            `json:"checkin_date"`
	CheckoutDate     string            `json:"checkout_date"`
	Guests           []Guest           `json:"guests"`
	Address          string            `json:"address"`
	Coordinates      Coordinates       `json:"coordinates"`
	CityGeoID        uint32            `json:"city_geo_id"`
	ImageURLTemplate string            `json:"image_url_template"`
	DocumentURL      string            `json:"document_url"`
	GeoID            uint32            `json:"geo_id"`
	Stars            uint8             `json:"num_stars"`
	State            DisplayOrderState `json:"state"`
	Payment          *HotelPayment     `json:"payment"`
}

type HotelPayment struct {
	Next HotelNextPayment `json:"next"`
}

type HotelNextPayment struct {
	Amount          HotelMoney `json:"amount"`
	PenaltyIfUnpaid HotelMoney `json:"penalty_if_unpaid"`
	PaymentEndsAt   string     `json:"payment_ends_at"`
}

type HotelMoney struct {
	Value    decimal.Decimal `json:"value"`
	Currency string          `json:"currency"`
}

type Guest struct {
	FirstName string
	LastName  string
}

type Coordinates struct {
	Latitude  float64 `json:"latitude"`
	Longitude float64 `json:"longitude"`
}
