package models

type OrderItem struct {
	Avia  *AviaItem  `json:"avia_item"`
	Hotel *HotelItem `json:"hotel_item"`
	Train *TrainItem `json:"train_item"`
	Bus   *BusItem   `json:"bus_item"`
}

type OrderType string

const (
	OrderTypeAvia  OrderType = "AVIA"
	OrderTypeHotel OrderType = "HOTEL"
	OrderTypeTrain OrderType = "TRAIN"
)

func (o OrderItem) HasAvia() bool {
	return o.Avia != nil
}

func (o OrderItem) HasHotel() bool {
	return o.Hotel != nil
}

func (o OrderItem) HasTrain() bool {
	return o.Train != nil
}

func (o OrderItem) HasBus() bool {
	return o.Bus != nil
}

func (o OrderItem) ID() string {
	if o.HasAvia() {
		return o.Avia.ID
	}
	if o.HasTrain() {
		return o.Train.ID
	}
	if o.HasHotel() {
		return o.Hotel.ID
	}
	if o.HasBus() {
		return o.Bus.ID
	}
	return ""
}
