package models

type TrainItem struct {
	ID            string            `json:"id"`
	YandexOrderID string            `json:"yandex_order_id"`
	PassportID    string            `json:"passport_id"`
	Type          OrderType         `json:"type"`
	OrderInfo     TrainOrderInfo    `json:"order_info"`
	State         DisplayOrderState `json:"state"`
}

type TrainDirection string

const (
	TrainDirectionForward  TrainDirection = "FORWARD"
	TrainDirectionBackward TrainDirection = "BACKWARD"
)

type TrainSegmentInfo struct {
	Direction         TrainDirection   `json:"direction"`
	ReservationNumber string           `json:"reservation_number"`
	PartnerOrderID    uint64           `json:"partner_order_id"`
	Arrival           string           `json:"arrival"`
	Departure         string           `json:"departure"`
	StationFrom       Station          `json:"station_from"`
	StationTo         Station          `json:"station_to"`
	TrainInfo         TrainInfo        `json:"train_info"`
	CarType           CarType          `json:"car_type"`
	CarNumber         string           `json:"car_number"`
	Passengers        []TrainPassenger `json:"passengers"`
}

type TicketRzhdStatus string

const TicketRzhdStatusRefunded TicketRzhdStatus = "REFUNDED"

type TrainPassengerCategory string

const TrainPassengerCategoryBabyWithoutPlace TrainPassengerCategory = "BabyWithoutPlace"

type TrainPassenger struct {
	Category         TrainPassengerCategory `json:"category"`
	TicketRzhdStatus TicketRzhdStatus       `json:"ticket_rzhd_status"`
}

type TrainInfo struct {
	BrandTitle           string `json:"brand_title"`
	TrainTitle           string `json:"train_title"`
	IsSuburban           string `json:"is_suburban"`
	TrainTicketNumber    string `json:"train_ticket_number"`
	TrainNumber          string `json:"train_number"`
	StartSettlementTitle string `json:"start_settlement_title"`
	EndSettlementTitle   string `json:"end_settlement_title"`
}

type CarType string

const (
	CarTypeUnknown      CarType = "Unknown"      // Не определен
	CarTypeShared       CarType = "Shared"       // Общий
	CarTypeSoft         CarType = "Soft"         // Люкс
	CarTypeLuxury       CarType = "Luxury"       // СВ
	CarTypeCompartment  CarType = "Compartment"  // Купе
	CarTypeReservedSeat CarType = "ReservedSeat" // Плацкарт
	CarTypeSedentary    CarType = "Sedentary"    // Сидячий
	CarTypeBaggage      CarType = "Baggage"      // Багажный
)

type TrainOrderInfo struct {
	Segments []TrainSegmentInfo `json:"segments"`
}

type Station struct {
	ID              int        `json:"id"`
	Title           string     `json:"title"`
	Timezone        string     `json:"timezone"`
	RailwayTimezone string     `json:"railway_timezone"`
	Settlement      Settlement `json:"settlement"`
}

type Settlement struct {
	ID                 int    `json:"id"`
	GeoID              int    `json:"geoId"`
	Title              string `json:"title"`
	TitleAccusative    string `json:"title_accusative"`
	TitleGenitive      string `json:"title_genitive"`
	TitlePrepositional string `json:"title_prepositional"`
	TitleLocative      string `json:"title_locative"`
	Preposition        string `json:"preposition"`
}
