package validation

import (
	"fmt"
	"strings"

	"a.yandex-team.ru/travel/komod/trips/internal/orders"
)

func CheckByPassportID(passportID string, orders ...orders.Order) error {
	var failIDs []string
	for _, order := range orders {
		if order.PassportID() != passportID {
			failIDs = append(failIDs, order.ID().String())
		}
	}
	if len(failIDs) != 0 {
		return fmt.Errorf(
			"unexpected orders (ids=[%s]) for passportId=%s",
			strings.Join(failIDs, ", "),
			passportID,
		)
	}
	return nil
}
