package pgclient

import (
	"database/sql"
	"time"

	"golang.yandex/hasql"
)

var defaultPoolOptions = []PoolOption{
	MaxOpenPoolConns(100),
}

var defaultClusterOptions = []hasql.ClusterOption{
	hasql.WithUpdateInterval(2 * time.Second),
	hasql.WithNodePicker(hasql.PickNodeClosest()),
}

var DefaultInitTimeout = time.Minute

type PoolOption func(*sql.DB)

// pool setting per DB host
func MaxIdlePoolConns(conns int) PoolOption {
	return func(db *sql.DB) {
		db.SetMaxIdleConns(conns)
	}
}

// pool setting per DB host
func MaxOpenPoolConns(conns int) PoolOption {
	return func(db *sql.DB) {
		db.SetMaxOpenConns(conns)
	}
}

// pool setting per DB host
func PoolConnMaxLifetime(lifetime time.Duration) PoolOption {
	return func(db *sql.DB) {
		db.SetConnMaxLifetime(lifetime)
	}
}

type ClientOption func(client *Client)

func WithOnCheckedNode(onCheckedNode func(*sql.DB, time.Duration)) ClientOption {
	return func(client *Client) {
		client.onCheckedNode = onCheckedNode
	}
}
