package pgclient

import (
	"context"
	"database/sql"
	"reflect"
	"time"

	"golang.yandex/hasql"
	"golang.yandex/hasql/checkers"
	"gorm.io/driver/postgres"
	"gorm.io/gorm"
)

func gormWrapper(node hasql.Node) (*gorm.DB, error) {
	return gorm.Open(
		postgres.New(
			postgres.Config{
				Conn: node.DB(),
			},
		), &gorm.Config{},
	)
}

func (c *Client) nodeChecker(ctx context.Context, db *sql.DB) (bool, error) {
	start := time.Now()
	isPrimary, err := checkers.Check(ctx, db, "SELECT NOT pg_is_in_recovery()")
	latency := time.Since(start)
	if c.onCheckedNode != nil {
		go c.onCheckedNode(db, latency)
	}
	return isPrimary, err
}

func getNodeAddr(db *sql.DB) (nodeAddr string) {
	defer func() {
		if r := recover(); r != nil {
			nodeAddr = "unknown"
		}
	}()
	dbValue := reflect.Indirect(reflect.ValueOf(db))
	connector := dbValue.FieldByName("connector").Elem()
	connConfig := connector.FieldByName("ConnConfig")
	config := connConfig.FieldByName("Config")
	nodeAddr = config.FieldByName("Host").String()
	return
}
