package point

import (
	"a.yandex-team.ru/travel/komod/trips/internal/models"
	"a.yandex-team.ru/travel/komod/trips/internal/references"
	"a.yandex-team.ru/travel/library/go/geobase"
)

type Comparator struct {
	geoBase   geobase.Geobase
	reference references.References
	resolver  *Resolver
}

func NewComparator(
	geoBase geobase.Geobase,
	reference references.References,
	resolver *Resolver,
) *Comparator {
	return &Comparator{
		geoBase:   geoBase,
		reference: reference,
		resolver:  resolver,
	}
}

func (c *Comparator) SamePoints(pointA, pointB models.Point) bool {
	return pointA.GetKind() == pointB.GetKind() &&
		pointA.GetID() == pointB.GetID() &&
		pointA.GetGeoID() == pointB.GetGeoID()
}

func (c *Comparator) InSameCountry(pointA, pointB models.Point) bool {
	return c.isSamePointsWithResolving(pointA, pointB, c.resolver.GetCountry)
}

func (c *Comparator) InSameSubject(pointA, pointB models.Point) bool {
	return c.isSamePointsWithResolving(pointA, pointB, c.resolver.GetRegion)
}

func (c Comparator) isSamePointsWithResolving(
	pointA, pointB models.Point,
	resolver func(point models.Point) (models.Point, error),
) bool {
	if c.SamePoints(pointA, pointB) {
		return true
	}

	aCountry, err := resolver(pointA)
	if err != nil {
		return false
	}
	bCountry, err := resolver(pointB)
	if err != nil {
		return false
	}
	return c.SamePoints(aCountry, bCountry)
}
