package references

import (
	"fmt"

	"google.golang.org/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/repository"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type RegionRepository struct {
	baseRepository *repository.RegionRepository
}

func NewRegionRepository() *RegionRepository {
	return &RegionRepository{
		baseRepository: repository.NewRegionRepository(),
	}
}

func (cr *RegionRepository) Write(b []byte) (int, error) {
	region := &rasp.TRegion{}
	if err := proto.Unmarshal(b, region); err != nil {
		return 0, fmt.Errorf("RegionRepository:Write: %w", err)
	}
	cr.baseRepository.Add(region)
	return len(b), nil
}

func (cr *RegionRepository) Get(id int) (*rasp.TRegion, bool) {
	region, ok := cr.baseRepository.Get(id)
	return region, ok
}

func (cr *RegionRepository) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewRegionRepository()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*cr = *newState
	return nil
}
