package references

import (
	"fmt"

	"google.golang.org/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/repository"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type StationToSettlementsRepository struct {
	baseRepository *repository.Station2SettlementRepository
}

func NewStationToSettlementsRepository() *StationToSettlementsRepository {
	return &StationToSettlementsRepository{
		baseRepository: repository.NewStation2SettlementRepository(),
	}
}

func (sr *StationToSettlementsRepository) Write(b []byte) (int, error) {
	settlement := &rasp.TStation2Settlement{}
	if err := proto.Unmarshal(b, settlement); err != nil {
		return 0, fmt.Errorf("StationToSettlementsRepository:Write: %w", err)
	}
	sr.baseRepository.Add(settlement)
	return len(b), nil
}

func (sr *StationToSettlementsRepository) Get(id int) (*rasp.TStation2Settlement, bool) {
	stationToSettlement, ok := sr.baseRepository.Get(id)
	return stationToSettlement, ok
}

func (sr *StationToSettlementsRepository) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewStationToSettlementsRepository()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*sr = *newState
	return nil
}
