package activities

import (
	"context"
	"time"

	"a.yandex-team.ru/travel/komod/trips/internal/services/activities/models"
)

type AfishaClient interface {
	GetActivities(
		ctx context.Context,
		startDate time.Time,
		resultsLimit int,
		rawItemsLimit int,
		period int, // interval in days
		geoID int,
	) ([]models.AfishaEventInfo, error)
}

type IziTravelClient interface {
	GetActivities(
		ctx context.Context,
		resultsLimit int,
		geoID int,
	) ([]models.IziTravelTourInfo, error)
}
