package clients

import "time"

type AfishaConfig struct {
	TravelAPIHost  string        `yaml:"travel_api_host"`
	TravelAPITvmID uint32        `yaml:"travel_api_tvm_id"`
	RequestTimeout time.Duration `yaml:"request_timeout"`
}

var DefaultAfishaConfig = AfishaConfig{
	TravelAPIHost:  "https://api.travel-balancer-test.yandex.net",
	TravelAPITvmID: 2002548,
	RequestTimeout: 5 * time.Second,
}

type IziTravelConfig struct {
	TravelAPIHost  string        `yaml:"travel_api_host"`
	TravelAPITvmID uint32        `yaml:"travel_api_tvm_id"`
	RequestTimeout time.Duration `yaml:"request_timeout"`
}

var DefaultIziTravelConfig = IziTravelConfig{
	TravelAPIHost:  "https://api.travel-balancer-test.yandex.net",
	TravelAPITvmID: 2002548,
	RequestTimeout: 5 * time.Second,
}
