package models

type AfishaPayload struct {
	RegionLinguistics *Linguistics      `json:"region_linguistics"`
	RegionURL         string            `json:"region_url"`
	Events            []AfishaEventInfo `json:"events"`
	Coordinates       Coordinates       `json:"coordinates"`
}

type AfishaEventInfo struct {
	Name     string   `json:"name"`
	MinPrice *Price   `json:"min_price"`
	Type     string   `json:"type"`
	DateTime string   `json:"date_time"`
	DateText string   `json:"date_text"`
	ImageURL string   `json:"image_url"`
	Tags     []string `json:"tags"`
	EventURL string   `json:"event_url"`
}

type Price struct {
	Value    float64 `json:"value"`
	Currency string  `json:"currency"`
}

type Linguistics struct {
	NominativeCase    string `json:"nominative_case"`
	GenitiveCase      string `json:"genitive_case"`
	DativeCase        string `json:"dative_case"`
	PrepositionalCase string `json:"prepositional_case"`
	Preposition       string `json:"preposition"`
	LocativeCase      string `json:"locative_case"`
	DirectionalCase   string `json:"directional_case"`
	AblativeCase      string `json:"ablative_case"`
	AccusativeCase    string `json:"accusative_case"`
	InstrumentalCase  string `json:"instrumental_case"`
}

type Coordinates struct {
	Latitude  float64 `json:"latitude"`
	Longitude float64 `json:"longitude"`
}
