package cityimages

import (
	"time"
)

type Config struct {
	RequestTimeout   time.Duration `yaml:"request_timeout"`
	CachingInterval  time.Duration `yaml:"caching_interval"`
	FetchingInterval time.Duration `yaml:"fetching_interval"`
}

var DefaultConfig = Config{
	RequestTimeout:   2 * time.Second,
	CachingInterval:  time.Hour,
	FetchingInterval: 2 * time.Second,
}
